# 2a: CAFE12+ Forend
![CAFE12+ Forend Assembly](TopBreak_CAFE12+/Assembly_htmldoc.jpg)

A 12ga [Top Break](TopBreak.md) variant inspired by the venerable pipe shotgun.

The gun I set out to make when I started the project.
Since it's built with \#Liberator12k platform components it features:

* Optics-ready Picatinny Rail
* QD Sling
* Modular components
* Ambidextrous

## The Easy Way
You can buy a kit from the [\#Liberator12k store](https://liberator12k.com/store/)
for the CAFE12+, which includes everything you need for the
better, faster, stronger 4130 alloy steel tubing version of the gun.

## CAFE12 or CAFE2+
This is the documentation for the **Plus Version** using 4130 tube instead of
Schedule 40 pipe. 3/4" Schedule 40 pipes and 4130 tube are different sizes,
so the CAFE12 and CAFE12+ forends do not share parts.
See [Chapter 2b: CAFE12 Forend](TopBreak_CAFE12.md) if you're sourcing your
own barrel from pipe.

<!-- NEW PAGE -->
## Prints
STL Files Location: `Forend/TopBreak_CAFE12+/Prints/`

|ReceiverFront|Forend|BarrelCollar|Extractor|
|-|-|-|-|
|![](TopBreak_CAFE12+/Prints/ReceiverFront_thumb.jpg)|![](TopBreak_CAFE12+/Prints/Forend_thumb.jpg)|![](TopBreak_CAFE12+/Prints/BarrelCollar_thumb.jpg)|![](TopBreak_CAFE12+/Prints/Extractor_thumb.jpg)|

|LatchTab|Cluster|Vertical Foregrip|Sightpost|
|-|-|-|-|
|![](TopBreak_CAFE12+/Prints/LatchTab_thumb.jpg)|![](TopBreak_CAFE12+/Prints/Cluster_thumb.jpg)|![](TopBreak_CAFE12+/Prints/VerticalForegrip_thumb.jpg)|![](TopBreak_CAFE12+/Prints/Sightpost_thumb.jpg)|
<br/>

| Part              | Filament Used | Print Time @ 0.4mm |
|-------------------|-------------: |------------------: |
| ReceiverFront     | 57g           |             07h17m |
| Forend            | 189g          |           1d01h10m |
| BarrelCollar      | 114g          |             15h00m |
| Extractor         | 14g           |              1h55m |
| LatchBlock        | 114g          |             15h00m |
| Cluster           | ?g            |               ?h?m |
| Vertical Foregrip | ?g            |               ?h?m |
| **Total**         | 420g          |           2d08h09m |
<br/>

## Vitamins
| Purpose                | Part                             | Quantity |
|------------------------|----------------------------------|----------|
| Extractor Bit          | #2 flat 1/4" Hex Bit             | 1        |
| Extractor Retainer     | 1/4"x1" Dowel Pin                | 1        |
| Extractor Spring       | TODO: 12lb 5/6" OD 2.75" Long    | 1        |
| Latch Bars             | 1/4"x3" Square Rod               | 2        |
| Latch Screws           | #8-32x3/4" Flat Head Screw       | 2        |
| Latch Springs          | (same as sear spring)            | 2        |
| Cluster Bolts          | #8-32x1/2" Flat Head Screw       | 2        |
| Foregrip Bolt          | 1/4"-20x3.5" Flat Head Screw     | 1        |
| Foregrip Bolt Nut      | 1/4"-20 Heatset Insert           | 1        |
| Barrel Collar Bolts    | #8-32x1/2" Socket Head Screw     | 1        |
| Barrel Sleeve          | 1.25"x0.125" 4130 Tubing 8" Long | 1        |
| Barrel                 | 1"x0.093" 4130 Tubing 18.5" Long | 1        |
<br/>

### Metric BOM
TODO

<!-- NEW PAGE -->
## Post-Processing
If you purchased a kit, all the machining is already done for you - proceed to the
subassemblies.
To DIY all the parts yourself, read the Machining section and then come back here.

### Subassemblies

#### Foregrip Cluster
Install the *Foregrip Bolt Nut* on the inside of the *Cluster*.

#### Barrel Group
1. Insert the *Barrel Sleeve* into the rear of the *Cluster* and line up the threaded
holes on top.
2. Insert the *Barrel* into the front of the *Cluster*.
Extractor cutout-side first.
3. Headspace on a dummy cartridge.
The *Barrel Sleeve* should be flush and the *Barrel* slightly recessed.
4. Install the *Cluster Bolts*.
6. Install the *Foregrip Bolt* into the *Foregrip* and screw into the *Cluster*
from the bottom.

#### Extractor
1. Insert the *Extractor Bit* into the *Extractor*, shim it if loose.
2. File/sand the extractor's top/bottom/sides smooth.
3. Drop the *Extractor Spring* into the *Barrel Collar*'s large rectangular hole.
4. Insert the *Extractor* into the hole.
5. With the *Extractor* pressed inwards, install the *Extractor Retainer*.
You can access the top of the extractor from the large round hole for the barrel.

#### Latch
1. Insert the *Latch Springs* into the small square holes in the *Barrel Collar*.
2. Insert the *Latch Bars* into the square holes in the *Barrel Collar*.
3. Ensure the *Latch Bars* slide smoothly - file the holes if necessary.
4. Insert the two rectangular tabs of the *Latch* into the underside of the *Barrel Collar
5. Depress the *Latch Bars* while you install the *Latch Screws*.
6. Lube the slots and bars.

#### Forend
1. Rotate the *Barrel Collar* up into the *Forend*.
2. Holding the *Barrel Collar*, install the *Barrel Group* from the front.
3. Secure the *Barrel Collar Bolts*

### Machining

#### Drill and Tap the Barrel Sleeve
**DO NOT DRILL THE BARREL**

A fixture located at `Forend/TopBreak_CAFE12+/Fixtures/BarrelSleeveFixture.stl`
can be used to help you drill and tap your own *Barrel Sleeve*.

Using a \#8-32 tap, thread the hole in the middle of the fixture.
Use a 1.5" \#8-32 to hold the *Barrel Sleeve* in place, like a set screw.
Now you're ready to drill and tap the holes.

**DO NOT DRILL THE BARREL**

Drill the holes out with a \#29 wire bit, start out very slowly so the drill bit doesn't
walk on the round surface.
Be sure to clear your chips early and often, use lots of cutting fluid.

**Tip:** Use a small end mill to put a flat on it first, if you have one.
This will prevent the drill bit from wandering.

Once you've finished drilling and tapping, ensure the inside of the *Barrel Sleeve* is
clear of chips and debris.

#### Cut the Extractor Slot
File out a 1/4" wide slot in the 6-O'clock position for the extractor bit.
Aim for a 45 degree angle 1/8" deep.

File this same notch in a matching location on the barrel. This is easiest to do
with the *Barrel Sleeve* installed on the barrel so you can do both at once.
A large square-edged file makes quick work of this operation but you can also
use a Dremel or angle grinder (and a lot of finesse).

**Tip:** Use a vise.

#### Drill and Tap the Latch Bars
Drill and tap (#8-32) the *Latch Bars* 1" from the end
