# 1.3: Lower Receiver

![Lower Receiver Assembly](Lower/Assembly_htmldoc.jpg)

Provides a grip, trigger guard, means of attachment via T-lugs.
The printed parts are sandwiched and bolted together.
The mount is sandwiched in with the lower side plates.
The T-lug tabs secure the mount into the lower.
The lower mount couples the lower to the receiver.

<!-- NEW PAGE -->
## Prints
STL Files Location: `Receiver/Lower/Prints/`

|Lower_Left|Lower_Middle|Lower_Right|
|-|-|-|
|![](Lower/Prints/Lower_Left_thumb.jpg)|![](Lower/Prints/Lower_Middle_thumb.jpg)|![](Lower/Prints/Lower_Right_thumb.jpg)|

|Lower_MountFront|Lower_MountRear|
|-|-|
|![](Lower/Prints/Lower_MountFront_thumb.jpg)|![](Lower/Prints/Lower_MountRear_thumb.jpg)|

<!-- NEW PAGE -->
## Vitamins - Imperial
| Purpose                     | Part                         | Quantity |
|-----------------------------|------------------------------|----------|
| Lower Nut                   | #8-32 Heatset Nut (Short)    | 5        |
| Lower Bolt                  | #8-32x1.25 SS Flat-Head Bolt | 5        |
| Lower Pin                   | Universal Clevis Pin 1/4x2"  | 1        |
| Lower Pin Retaining Pin     | 6Dx2" Box Nail               | 1        |

## Vitamins - Metric
| Purpose                   | Part                                     | Quantity |
|---------------------------|------------------------------------------|----------|
| Lower Nut                 | M4 Heatset Nut (**M4xD7xL5**)            | 5        |
| Lower Bolt                | **DIN7991** M4x35 A2/A4 Countersunk Bolt | 5        |
| Lower Pin                 | None                                     | 1        |
| Lower Pin Retaining Pin   | 2.5x50mm Nail                            | 1        |

<!-- NEW PAGE -->
## Post-Processing

### Install Heatset Nuts
Install the heatset nuts into Lower_Left.

### Pin Retainer
Locate the small hole in the Lower_MountRear.
Insert Lower Pin Retaining Pin, press it into the mount until flush.

### Subassembly
Requires the trigger from the [Fire Control Group](../FCG.md).

1. Lay Lower_Left flat-side up.
2. Install Lower_MountFront - the extended portion points left.
3. Install Lower_MountRear - the extended portion points left.
4. Tuck the trigger up between the two LowerMounts.
5. Add Lower_Middle to the stack.
6. Add Lower_Right, it should seat on the LowerMount tabs.
7. Gently compress the stack by hand.

If there are large gaps in the stack, light tapping with a rubber mallet should
close them. If you need a lot of force, there's probably something binding.
Figure out what's bulging, and file it down. Needle files are great for this.

## Technical Notes

### Trigger Pull
File, sand smooth, and lube any friction surfaces that are dragging.
