# Appendix: Top-Break Common - Assembly

## Hardware Kit
If you purchased a kit, all the machining is already done for you.

To DIY all the parts yourself, read the [Top-Break Common Machining](TopBreak_Machining.md) section.

## Print Post-Processing
Tools you may use include:

* Needle File Set
* 1/2" Reamer
* 3/4" half-round file
* \#2 Square Drive Bit
* Sandpaper, ~100-300
* Superglue, 2-part epoxy, or other permanent adhesive.

### Forend
1. Ream the frame bolt holes.
1. Lightly apply permanent adhesive or epoxy to the *Reinforcement Screws*.
2. Screw the *Reinforcement Screws* into the forend and wipe off any excess.
4. Optional: sand the pivot surfaces smooth.
2. Oil the pivot surfaces.

### Barrel Collar

#### Pivot
1. Using pliers, peel off the supports from the pivot area.
2. Flush cutters can be used to clean up the flat portion.
3. Using a 3/4" half-round file, file the rounded inner pivot area smooth.
4. If there is any elephant's foot, file it off now.
5. Sand the inner curve of the pivot smooth with progressively finer grits.
6. Test fit by rotating the *Barrel Collar* up into the *Forend*.
7. Sand the inner and outer curves of the *Barrel Collar* pivot smooth.
8. If the pivoting action feels tight or sticks, it's probably elephant foot. Clean that up.

####

#### Extractor
1. Ream the *Extractor Retainer* hole to 1/4".
2. Insert the *Extractor Bit* into the *Extractor*, shim and add superglue if loose.
3. File/sand the extractor's top/bottom/sides smooth.
4. Drop the *Extractor Spring* into the *Barrel Collar*'s large rectangular hole.
5. Insert the *Extractor* into the hole.
6. With the *Extractor* pressed inwards, install the *Extractor Retainer* through the barrel hole.

#### Foregrip Cluster
1. Ream the *Cluster Bolts* holes.
2. Ream the *Handguard Bolt* hole.
3. Ream the *Vertical Foregrip Pin*.
2. Heatset the *Foregrip Nut* on the inside of the *Cluster*.
3. Heatset the *Handguard Bolt Nuts* in the sides at the back of the *Cluster*


#### Latch
1. Insert the *Latch Springs* into the small square holes in the *Barrel Collar*.
2. Insert the *Latch Bars* into the square holes in the *Barrel Collar*.
3. Ensure the *Latch Bars* slide smoothly - file the holes if necessary.
4. Insert the two rectangular tabs of the *Latch* into the underside of the *Barrel Collar
5. Depress the *Latch Bars* while you install the *Latch Screws*.
6. Lube the slots and bars.

#### Forend
1. Rotate the *Barrel Collar* up into the *Forend*.
2. Holding the *Barrel Collar*, install the *Barrel Group* from the front.
3. Secure the *Barrel Collar Bolts*
