# 1.2: Fire Control Group

![Fire Control Group](FCG/Assembly_htmldoc.jpg)

A fire control group for fixed recoil plate designs. Trigger is based on
[The Unknown Cat's](https://www.youtube.com/channel/UCNR0HGw5airGKkiPcquS0TA)
design.

The sear is a square rod with a cross-pin near the bottom.
An inclined slot in each side of the trigger forces the cross-pin and
sear downward when the trigger is pulled. A central support tab
keeps the sear and its return spring (not pictured) oriented vertically.

A compression spring located below the sear pushes the sear into the upward
position, driving the trigger forward via the sear pin.

A linear hammer strikes the firing pin, which protrudes through the recoil plate.

The FCG is designed to support slamfire via the optional disconnector.

<!-- NEW PAGE -->
## Prints
STL Files Location: `Receiver/FCG/Prints/`

|FCG_Housing|FCG_Disconnector|FCG_FiringPinCollar|FCG_ChargingHandle|
|-|-|-|-|
|![](FCG/Prints/FCG_Housing_thumb.jpg)|![](FCG/Prints/FCG_Disconnector_thumb.jpg)|![](FCG/Prints/FCG_FiringPinCollar_thumb.jpg)|![](FCG/Prints/FCG_ChargingHandle_thumb.jpg)|

|FCG_Hammer|FCG_HammerTail|FCG_TriggerMiddle|FCG_Trigger|
|-|-|-|-|
|![](FCG/Prints/FCG_Hammer_thumb.jpg)|![](FCG/Prints/FCG_HammerTail_thumb.jpg)|![](FCG/Prints/FCG_TriggerMiddle_thumb.jpg)|![](FCG/Prints/FCG_Trigger_thumb.jpg)


<!-- NEW PAGE -->
## Vitamins - Imperial
| Purpose                     | Part                                         | Quantity |
|-----------------------------|----------------------------------------------|----------|
| Charging Handle Bolt        | #8-32x1/4" SS Socket Cap Bolt                | 1        |
| Charging Handle Nut         | #8-32 Short Heatset Nut                      | 1        |
| Disconnector Pivot Pin      | 3/32"x3/4" Steel Pin                         | 1        |
| Disconnector Spring         | 0.22" OD 0.625" Long (0.02" wire)            | 1        |
| Firing Pin                  | 6Dx2" Box Nail, cut flush to 1.54" OAL       | 1        |
| Firing Pin Spring           | 0.22" OD 0.625" Long (0.02" wire)            | 1        |
| Hammer Bolt                 | 1/4-20x5" Flat Head Bolt                     | 1        |
| Hammer Bolt Sleeve          | 9/32"x3.5" K&S Brass Tube                    | 1        |
| Hammer Cap Nut              | 1/4-20" Acorn Nut                            | 1        |
| Hammer Nut                  | 1/4-20" Heatset Nut (Short)                  | 1        |
| Hammer Spring               | 0.052x0.625x3" ~6.3lbs/in Compression Spring | 1        |
| Recoil Plate (L12k)         | #Liberator12k Official Alloy Recoil Plate    | 1\*      |
| Recoil Plate (DIY)          | 2x2-3/8x3/8" Mild Steel Plate                | 1\*      |
| Recoil Plate Center Bolts   | #8-32x1.5 SS Flat-Head Bolt                  | 2        |
| Recoil Plate Side Bolts     | #8-32x0.5 SS Flat-Head Bolt                  | 4        |
| Sear                        | 1/4"x1.67" Steel Square Rod                  | 1        |
| Sear Pin                    | 3/32"x1/2" Music Wire                        | 1        |
| Sear Return Spring          | 0.02" Wire, 0.25"x1.25"                      | 1        |

\* Pick one, these parts have alternates.

<!-- NEW PAGE -->
## Vitamins - Metric
| Purpose                   | Part                                                 | Quantity |
|---------------------------|------------------------------------------------------|----------|
| Charging Handle Bolt      | TODO: **DIN????** M4x1/4" SS Socket Cap Bolt         | 1        |
| Charging Handle Nut       | TODO: M4 Heatset                                     | 1        |
| Disconnector Pivot Pin    | 2.5x18mm Stainless Steel Pin                         | 1        |
| Disconnector Spring       | 0.5mm Wire, 6mm OD, 20mm Length Spring (Cut to 16mm) | 1        |
| Firing Pin                | 2.5x50mm Nail, , cut flush to 40mm OAL               | 1        |
| Firing Pin Spring         | 0.5mm Wire, 6mm OD, 20mm Length Spring (Cut to 16mm) | 1        |
| Hammer Bolt               | **DIN7991** M6x130 Countersunk Bolt                  | 1        |
| Hammer Bolt Sleeve        | 6mm ID Sleeve for _Hammer Bolt_                      | 1        |
| Hammer Cap Nut            | **DIN1587** M6 Domed Hex Cap Nut                     | 1        |
| Hammer Nut                | M6 Heatset Nut (**M6xD9.5xL6**)                      | 1        |
| Hammer Spring             | 1.4mm Wire, 16mm OD, 80mm Length Spring              | 1        |
| Recoil Plate (L12k)       | None                                                 | 1\*      |
| Recoil Plate (DIY)        | 6mm Thickness 50.80x60.325mm AISI 4140 Steel Plate   | 1\*      |
| Recoil Plate Center Bolts | **DIN7991** M4x40 A2/A4 Countersunk Bolt             | 2        |
| Recoil Plate Side Bolts   | **DIN7991** M4x40 A2/A4 Countersunk Bolt             | 4        |
| Sear                      | 6mm x 42.42mm Steel Square Rod                       | 1        |
| Sear Pin                  | None                                                 | 1        |
| Sear Return Spring        | 0.5mm Wire, 6.5mm OD, 35mm Length Spring             | 1        |

\* Pick one, these parts have alternates.


<!-- NEW PAGE -->
## Post-Processing

### Trigger Subassembly

1. Insert the trigger middle portion into the glued sides. It should slide freely.
2. Drop the sear return spring into the trigger middle.
3. Insert the sear and and compress the return spring until the pin hole is visible through the side slot.
4. Insert cross-pin through the inclined slot through the sear. It should lay flush or just below the surface of the trigger sides.
5. Verify the trigger moves freely.
6. Lube the cross-pin hole, both sides of the slot, front and rear of the sear.
7. Squeezing the trigger should now feel silky smooth.

### Hammer Subassembly

Install the 1/4-20" heatset nut into the rear of the hammer (the portion with the large pocket) and wait to cool.

Install the hammer bolt and slip the hammer bolt sleeve over the extended portion. Add the hammer spring, hammer tail.
Finally, install the hammer cap nut with threadlocker.

### Firing Pin Subassembly

Prepare the firing pin by cutting the 6D box nail to 1.535" in length. Cut generously, file flush and gently round the
outer edge of the end. Sand smooth with 220 grit or finer.

Ream the firing pin collar hole to 2.5mm and install into the firing pin collar from the rear, the flared portion is
forward.

Install the firing pin spring into the flared portion of the firing pin collar.

### Charging Handle

Install the \#8-32 heatset nut into the charging handle and allow to cool.

Before installing the \#8-32x1/4" Socket Cap Screw, chuck it up in a drill and file/sand the side of the bolt cap
smooth. Then install the bolt into the charging handle from the underside.

## DIY Hardware
If you don't want to purchase a kit from the
[Liberator12k.com Store](https://liberator12k.com/store/),
you can make your own. It won't be faster or cheaper, but all the information
you need is freely available and the hardware is available at your local
hardware store or metal supplier.

### Sear
 * 1/8" hole 5/16" from the bottom for the sear cross-pin
 * This hole should be drilled under-size and reamed if possible.
 * Filing any burrs is Good Enough

### Sear Cross-Pin
 * 3/32" Music Wire
 * 1/2" long
 * Ends should be slightly rounded and smooth.

### Recoil Plate
| Required Tool    | Metric Alternative |
|------------------|--------------------|
| #8-32 Tap        | M4 Tap             |
| #29 Drill Bit    | 3.5mm Drill Bit    |
| 5/16" Drill Bit  | 8mm Drill Bit      |
| 2.5mm Drill Bit  | N/A                |

#### Instructions
The full How To is incomplete, but at a high level:

1. Print a Recoil Plate template (TODO).
2. Mark the holes with a punch and drill to specified size.
3. Tap the holes for the tension rods and FCG Housing holes with #8-32.

<!-- NEW PAGE -->
## Technical Notes

### Recoil Plate
2" wide (fits between the frame bolts) and 2.375" high, 1/4" thick.
This covers the tension rods and provides room for the revolver spindle pin.

### Firing Pin
When the hammer is in the full forward position, the back of the *Firing Pin*
will be flush with the back of the *FCG Housing*, meaning anything beyond 1.5"
will stick out of front of the recoil plate.

However... nails have a pointed tip - and you have to cut that off..
plus a little deformed metal rear of the tip. So plan for some loss.
A bare minimum of, 40mm worth of nail to work with.

The nail is intended to be glued into the collar, and the collar is indexed with
wide flats, so it can't rotate - making it rimfire-friendly.

#### Why won't my firing pin fit? It's a 6D, but it's got a 2.75mm shaft
You've got "Common" nails. You need 6D "Box" nails - they're thinner. Sorry :)
A 6D Box nail has a 2.4mm shaft.

### Hammer Spring
There's some flexibility here. "If it fits, I sits." >5/16" ID and < 5/8" OD.

You shouldn't need a stupid strong spring - 10lb is probably too much,
but it shouldn't ever be an issue for the FCG. The hammer tail would probably
fail first, or the charging handle bolt. If you can't charge it by hand, it's
too strong.

### Trigger Pull
The coefficient of friction for lubed steel/steel is ~0.16, the trigger has a
mechanical advantage of 1.5. Give or take, trigger pull is 10% of hammer spring.

Plastic-on-plastic friction probably contributes much more to trigger pull than
the hammer spring does.

For improved performance:
1. Polish and lube the sear surfaces and pin.
2. Sand/polish the friction surfaces of the trigger sides.
3. Use a needle file to clean up the inclined slot in the Trigger.
4. Sand/polish slot smooth.
